/*
 * Decompiled with CFR 0.152.
 */
package com.hoshino.cti.Modifier;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.common.ForgeHooks;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ModifierRemovalHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileLaunchModifierHook;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.NamespacedNBT;

public class CombustorModifier
extends NoLevelsModifier
implements MeleeDamageModifierHook,
ProjectileLaunchModifierHook,
ModifierRemovalHook,
TooltipModifierHook {
    public static final ResourceLocation fuel = new ResourceLocation("cti:combust_fuel");
    public static final ResourceLocation fuel_quality = new ResourceLocation("cti:fuel_quality");

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook((Object)this, new ModuleHook[]{ModifierHooks.MELEE_DAMAGE, ModifierHooks.PROJECTILE_LAUNCH, ModifierHooks.REMOVE, ModifierHooks.TOOLTIP});
    }

    public float getMeleeDamage(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float baseDamage, float damage) {
        LivingEntity livingEntity = context.getAttacker();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            float f = this.getBonus(tool);
            this.shrinkFuel(tool, player);
            return damage + baseDamage * f;
        }
        return damage;
    }

    public void onProjectileLaunch(IToolStackView tool, ModifierEntry modifier, LivingEntity shooter, Projectile projectile, @javax.annotation.Nullable AbstractArrow arrow, NamespacedNBT persistentData, boolean primary) {
        if (shooter instanceof Player) {
            Player player = (Player)shooter;
            float f = this.getBonus(tool);
            this.shrinkFuel(tool, player);
            projectile.m_20256_(projectile.m_20184_().m_82490_((double)(1.0f + f)));
        }
    }

    public float getBonus(IToolStackView tool) {
        return tool.getPersistentData().getFloat(fuel_quality);
    }

    public void addFuel(IToolStackView tool, Player player) {
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (ForgeHooks.getBurnTime((ItemStack)stack, (RecipeType)RecipeType.f_44108_) <= 0 || stack.hasCraftingRemainingItem()) continue;
            tool.getPersistentData().putInt(fuel, ForgeHooks.getBurnTime((ItemStack)stack, (RecipeType)RecipeType.f_44108_));
            tool.getPersistentData().putFloat(fuel_quality, Math.min((float)ForgeHooks.getBurnTime((ItemStack)stack, (RecipeType)RecipeType.f_44108_) / 3200.0f, 4.5f));
            stack.m_41774_(1);
            player.m_216990_(SoundEvents.f_11705_);
        }
    }

    public void shrinkFuel(IToolStackView tool, Player player) {
        tool.getPersistentData().putInt(fuel, (int)((float)tool.getPersistentData().getInt(fuel) - tool.getPersistentData().getFloat(fuel_quality) * 50.0f));
        if (tool.getPersistentData().getInt(fuel) <= 0) {
            tool.getPersistentData().putInt(fuel, 0);
            this.addFuel(tool, player);
        }
        if (tool.getPersistentData().getInt(fuel) <= 0) {
            tool.getPersistentData().putInt(fuel_quality, 0);
        }
    }

    @Nullable
    public Component onRemoved(IToolStackView tool, Modifier modifier) {
        tool.getPersistentData().remove(fuel);
        tool.getPersistentData().remove(fuel_quality);
        return null;
    }

    public Component getDisplayName(IToolStackView tool, ModifierEntry entry) {
        return super.getDisplayName().m_6881_().m_130946_(" \u4f24\u5bb3\u589e\u52a0 +" + String.format("%.1f", Float.valueOf(this.getBonus(tool) * 100.0f)) + "%");
    }

    public void addTooltip(IToolStackView tool, ModifierEntry modifierEntry, @Nullable Player player, List<Component> list, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        list.add((Component)Component.m_237113_((String)"\u71c3\u6599:").m_130946_(String.valueOf(tool.getPersistentData().getInt(fuel))).m_130948_(this.getDisplayName().m_7383_()));
    }
}

